local assets =
{
    Asset("ANIM", "anim/moon_tree_petal.zip"),
    Asset("ANIM", "anim/meat_rack_food_petals.zip"),
}

local prefabs =
{
	"moon_tree_blossom_worldgen",
    "moon_tree_blossom_dried",
}

local function OnPutInInventory(inst, pickupguy, src_pos)
    inst.components.perishable:StartPerishing()
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst) -- so it can be dropped as loot

    inst.AnimState:SetBank("moon_tree_petal")
    inst.AnimState:SetBuild("moon_tree_petal")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:SetRayTestOnBB(true)

    inst.pickupsound = "vegetation_grassy"

    inst:AddTag("cattoy")
    inst:AddTag("vasedecoration")
	--dryable (from dryable component) added to pristine state for optimization
	inst:AddTag("dryable")

    MakeInventoryFloatable(inst)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)

    inst:AddComponent("tradable")
    inst:AddComponent("vasedecoration")

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("edible")
    inst.components.edible.healthvalue = TUNING.HEALING_TINY
    inst.components.edible.hungervalue = 0
    inst.components.edible.foodtype = FOODTYPE.VEGGIE

    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_FAST)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"

    inst:AddComponent("dryable")
    inst.components.dryable:SetProduct("moon_tree_blossom_dried")
    inst.components.dryable:SetDryTime(TUNING.DRY_FAST)
	inst.components.dryable:SetBuildFile("meat_rack_food_petals")
    inst.components.dryable:SetDriedBuildFile("meat_rack_food_petals")

    MakeSmallBurnable(inst)
    MakeSmallPropagator(inst)

	MakeHauntableLaunch(inst)

    return inst
end

local function ground_fn()
	local inst = fn()

    inst:SetPrefabName("moon_tree_blossom")

    if not TheWorld.ismastersim then
        return inst
    end

	inst.components.perishable:StopPerishing()
	return inst
end

return Prefab("moon_tree_blossom", fn, assets, prefabs),
	Prefab("moon_tree_blossom_worldgen", ground_fn, assets)
